param([string]$InstanceName, [string]$DatabaseNames, [string]$CustomSQLName)

$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -match "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
	$InstanceName = $InstanceName.Replace("'","")
}

$ConnectionString = $ComputerName + '\' + $InstanceName
#write-output "ConnString - $ConnectionString"

$Query = @"
declare @MajorVersion tinyint = LEFT(CAST(SERVERPROPERTY('ProductVersion') AS nvarchar(max)),CHARINDEX('.',CAST(SERVERPROPERTY('ProductVersion') AS nvarchar(max)))-1) 
declare @SQL varchar(255) = N'DBCC LOGINFO(' + CONVERT(nvarchar(11), DB_ID('$DatabaseNames')) + N') WITH NO_INFOMSGS'

IF OBJECT_ID(N'tempdb..#LogInfo', N'U') IS NOT NULL
  DROP TABLE #LogInfo

CREATE TABLE #LogInfo (RecoveryUnitId int NOT NULL --available in SQL Server 2012+
  , FileId      smallint     NOT NULL
  , FileSize    float        NOT NULL
  , StartOffset bigint       NOT NULL
  , FSeqNo      bigint       NOT NULL
  , Status      int          NOT NULL
  , Parity      tinyint      NOT NULL
  , CreateLSN   nvarchar(24) NOT NULL
)

IF @MajorVersion < 11
  ALTER TABLE #LogInfo DROP COLUMN RecoveryUnitId

insert into #LogInfo  
  exec (@SQL)  

select count(1) as VLFcount from #LogInfo

IF OBJECT_ID(N'tempdb..#LogInfo', N'U') IS NOT NULL
  DROP TABLE #LogInfo
"@
try{
    $Datatable = New-Object System.Data.DataTable
    
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()
 
#    $Datatable.Rows | FT *


if (($Datatable.rows).count -ge 1)
{
    $FormatedData = $Datatable.Rows | FW | out-string
    $FormatedData = [int]$FormatedData
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData
}
else{write-output "0"}
}

Catch
{write-output "-1"
$ConnectionString
$Exception = $_.Exception.Message
if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
write-output $Exception
}