param([string]$InstanceName, [int]$TimePeriod, [string]$CustomSQLName)

if ($TimePeriod -gt 0)
{
$StrLength = 4096

if ($CustomSQLName){$ComputerName=$CustomSQLName}
else {$ComputerName=(Get-WmiObject Win32_Computersystem).name}

if ($InstanceName -match "SQLServer"){$InstanceName = ""}
else {$InstanceName = $InstanceName.Replace('MSSQL$',"")
	$InstanceName = $InstanceName.Replace("'","")
}

$ConnectionString = $ComputerName + '\' + $InstanceName
#write-output "ConnString - $ConnectionString"

$Query = @"
    select d.database_id, d.name
    from sys.databases d left join sys.dm_database_encryption_keys k on k.database_id = d.database_id
    where k.encryption_state is null and d.database_id > 4
    order by d.database_id
"@
try{
    $Datatable = New-Object System.Data.DataTable
    
    $Connection = New-Object System.Data.SQLClient.SQLConnection
    $Connection.ConnectionString = "server=$ConnectionString;database='master';trusted_connection=true;"
    $Connection.Open()
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $Connection
    $Command.CommandText = $Query
    $Reader = $Command.ExecuteReader()
    $Datatable.Load($Reader)
    $Connection.Close()
 
#    $Datatable.Rows | FT *


if (($Datatable.rows).count -ge 1)
{
    $FormatedData = $Datatable.Rows | FL | out-string
    if($FormatedData.Length -gt $StrLength) {$FormatedData = $FormatedData.substring(0, $StrLength)}
    write-output $FormatedData
}
else{write-output "Result: none"}
}

Catch
{write-output "Result: none"
$ConnectionString
$Exception = $_.Exception.Message
if($Exception.Length -gt $StrLength) {$Exception = $Exception.substring(0, $StrLength)}
write-output $Exception
}
}
else{write-output "Result: none"}